/*
 * Decompiled with CFR 0.152.
 */
package frc.emul.periph.keyboard;

import frc.emul.config.Configuration;
import frc.emul.config.data.CfgItemKeySwitch;
import frc.emul.periph.IPeripheral;
import frc.emul.periph.keyboard.IKeyMapping;
import frc.emul.periph.keyboard.KeyMapping;
import frc.emul.periph.keyboard.ScanCode;
import frc.emul.periph.misc.AbstractDevice;
import java.awt.Component;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.List;

public class PS2Keyboard
extends AbstractDevice
implements IPeripheral.TickHandler,
IPeripheral.WriteHandler,
KeyListener {
    public static final boolean TRACE = false;
    public static final String NAME = "Keyboard";
    private static final float CLK_PERIOD = 1.0E-4f;
    private static final float CLK_FREQUENCY = 10000.0f;
    private static final int CYCLES_ACTIVATION = 80;
    private static final int CYCLES_CLK_PERIOD = 160;
    private static final int CYCLES_CLK_SWITCH = 80;
    private static final int CYCLES_DATA_ACCESS_DELAY = 40;
    private static final int STATUS_OFF = -2;
    private static final int STATUS_ACTIVATING = -1;
    private static final int BUFFER_SIZE = 16;
    private static final int OUT_DATA = 2;
    private static final int OUT_CLK = 1;
    private static final int OUT_BUTTONS_OFF = 15;
    private final List<ScanCode> pool;
    private final List<ScanCode> buffer;
    private int bitOut = -1;
    private int countDown;
    private boolean newPeriod;
    private boolean scanned;
    private boolean lastWrittenClk;
    private IKeyMapping mapping = new KeyMapping();
    private ScanCode currentScanCode;
    private int currentByteOut;
    private int out = 15;
    private boolean parity;
    private boolean engaged;
    private int vkON;
    private int vkOFF;

    public PS2Keyboard() {
        this.buffer = new ArrayList<ScanCode>(16);
        this.pool = new ArrayList<ScanCode>(16);
        this.resetBuffer();
    }

    public void setMapping(IKeyMapping iKeyMapping) {
        this.mapping = iKeyMapping;
    }

    public final synchronized boolean isBufferEmpty() {
        return this.buffer.isEmpty();
    }

    public final synchronized boolean isBufferFull() {
        return this.pool.isEmpty();
    }

    public final synchronized ScanCode readBuffer() {
        return this.isBufferEmpty() ? null : this.buffer.remove(0);
    }

    public final boolean appendKeyPressed(KeyEvent keyEvent) {
        return this.appendKey(keyEvent.getKeyCode(), keyEvent.getKeyLocation(), false);
    }

    public final boolean appendKeyReleased(KeyEvent keyEvent) {
        return this.appendKey(keyEvent.getKeyCode(), keyEvent.getKeyLocation(), true);
    }

    public final synchronized boolean appendKey(int n, int n2, boolean bl) {
        int n3;
        if (!this.isBufferFull() && (n3 = this.mapping.getScanCode(n, n2)) != 0) {
            ScanCode scanCode = this.pool.remove(this.pool.size() - 1);
            scanCode.reset(bl, n3);
            this.buffer.add(scanCode);
            return true;
        }
        return false;
    }

    public synchronized void reset() {
        this.clearOutput();
        this.resetBuffer();
    }

    public String getName() {
        return NAME;
    }

    public String getID() {
        return "KEYBOARD";
    }

    public final int getButtonsState() {
        return this.out;
    }

    public void plug(Component component, int n) {
        if (component != null) {
            component.addKeyListener(this);
        }
        this.engaged = false;
    }

    public void unplug(Component component, int n) {
        if (component != null) {
            component.removeKeyListener(this);
        }
    }

    public boolean consumes(InputEvent inputEvent) {
        return this.engaged && inputEvent instanceof KeyEvent;
    }

    public void applyConfiguration(Configuration configuration, int n) {
        CfgItemKeySwitch cfgItemKeySwitch = configuration.keyMapping.keyboard;
        this.vkOFF = cfgItemKeySwitch.keyOFF.getCode();
        this.vkON = cfgItemKeySwitch.keyON.getCode();
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (this.engaged && keyEvent.getKeyCode() != this.vkOFF) {
            this.appendKeyPressed(keyEvent);
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (this.engaged) {
            if (n != this.vkOFF) {
                this.appendKeyReleased(keyEvent);
            } else {
                this.engaged = false;
                System.out.println("Keyboard disengaged");
            }
        } else if (n == this.vkON) {
            this.engaged = true;
            System.out.println("Keyboard engaged");
        }
    }

    public void handleWrite(int n, int n2) {
        if (14 != n) {
            return;
        }
        boolean bl = (n2 & 0x40) != 0;
        if (bl & !this.lastWrittenClk) {
            this.setScanned((n2 & 0x80) == 0);
        }
        this.lastWrittenClk = bl;
    }

    public final void handleTick(int n) {
        if (!this.scanned) {
            return;
        }
        if ((this.countDown -= n) <= 0) {
            if (this.newPeriod && this.bitOut != -1) {
                this.out ^= 1;
            }
            if ((this.out & 1) != 1) {
                this.countDown += 80;
            } else {
                this.countDown += 40;
                if (this.newPeriod) {
                    this.newPeriod = false;
                    ++this.bitOut;
                } else {
                    this.newPeriod = true;
                    switch (this.bitOut) {
                        case 0: {
                            this.currentByteOut = this.readNextByte();
                            if (this.currentByteOut == 0) {
                                this.clearOutput();
                                return;
                            }
                            this.parity = true;
                            this.setData(false);
                            break;
                        }
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: 
                        case 8: {
                            if ((this.currentByteOut & 1) == 1) {
                                this.setData(true);
                                this.parity = !this.parity;
                            } else {
                                this.setData(false);
                            }
                            this.currentByteOut >>= 1;
                            break;
                        }
                        case 9: {
                            this.setData(this.parity);
                            break;
                        }
                        case 10: {
                            this.setData(true);
                            break;
                        }
                        case 11: {
                            this.setData(true);
                            this.bitOut = 10;
                            break;
                        }
                        default: {
                            throw new RuntimeException("Invalid bit state #" + this.bitOut);
                        }
                    }
                }
            }
        }
    }

    private final synchronized void setScanned(boolean bl) {
        if (bl == this.scanned) {
            return;
        }
        if (bl) {
            this.bitOut = -1;
            this.countDown = 80;
            this.out = 3;
            this.newPeriod = true;
            this.scanned = true;
        } else {
            this.clearOutput();
        }
    }

    private final void clearOutput() {
        this.scanned = false;
        this.bitOut = -2;
        this.out = 15;
    }

    private final void resetBuffer() {
        this.currentScanCode = null;
        this.pool.clear();
        this.buffer.clear();
        int n = 16;
        while (n-- > 0) {
            this.pool.add(new ScanCode());
        }
    }

    private final synchronized int readNextByte() {
        if (this.currentScanCode != null) {
            if (this.currentScanCode.hasNextByte()) {
                return this.currentScanCode.getNextByte();
            }
            this.pool.add(this.currentScanCode);
        }
        if (this.isBufferEmpty()) {
            this.currentScanCode = null;
            return 0;
        }
        this.currentScanCode = this.buffer.remove(0);
        return this.currentScanCode.getNextByte();
    }

    private final void setData(boolean bl) {
        this.out = bl ? (this.out |= 2) : (this.out &= 0xFFFFFFFD);
    }
}

